
{... here's how we copied the bitImage and locTable of Cairo font...}

TYPE {GLOBAL types used for this procedure}
	FintPtr = ^FontRec;
  FontHandle = ^FintPtr;{FintPtr???, because FontPtr is already declared!}

var   {GLOBAL varibles used in this procedure}
	myFont:			FontHandle;{so we can load resource and access FontRec}
	FontMap:		BitMap;{will point to copy of font bitimage}
	RowWords:		integer;
	RowBytes:		integer;
	tPtr:				Ptr;
	tLong:			Longint;
	BitPtr:			Ptr;{pointer to our Copy of BitImage}
	Locate:			Array[0..130] of integer;{'partial' Cairo location table}
	LocatePtr:	Ptr;
  
procedure CreateCairoStuff;
var
	trect:Rect;
Begin
	{load Cairo font and make copies of Character image and locate table}
	myFont := FontHandle(GetResource('FONT',1426));
	HLock(Handle(myFont));{lock it so it won't move... pointers!}
	RowWords := myFont^^.rowWords;{number of words in row}
	RowBytes := RowWords * 2;{number of bytes in row}

	{make tPtr point to start of fontRec bitimage}
	tPtr := @myFont^^.rowWords;{field just before the  bitimage}
	tLong := ORD(tPtr);{coerce to longint,i-80}
	tLong := tLong + 2;{2 bytes to get to beginning of bit image,i-234}
	tPtr := Pointer(tLong);{coerce back to pointer}

	{create BitPtr size of the bitimage}
	BitPtr := NewPtr(RowBytes * myFont^^.fRectHeight);
	{bytes to move = bytes per row * number of rows....}
	BlockMove(tPtr,BitPtr,RowBytes * myFont^^.fRectHeight);{make the move!}

	{make tPtr point to start of fontRec locTable.. just beyond bitimage}
	tPtr := @myFont^^.rowWords;{find start of LocTable for font}
	tLong := ORD(tPtr);{coerce to longint,i-80}
	tLong := tLong + (RowBytes * myFont^^.fRectHeight) + 2;{bitimage + integer}
	tPtr := Pointer(tLong);{coerce back to pointer}

	{make LocatePtr point to start of our Locate table}
	LocatePtr := @Locate[0];
	{bytes to move = (last char + 1) * 2.. in our case (130+1)*2 = 262}
	{or Locate[] contains 131 integers (zero based) = 262 bytes}
	BlockMove(tPtr,LocatePtr,262);{copy LocTable to our Locate array}

	{for Cairo: Locate[130] = 1656.. offset to rightside of last character,
	use ResEdit to look at last char of font... will give this OffSet}
	SetRect(tRect,0,0,Locate[130],myFont^^.fRectHeight);

	FontMap.baseAddr := QDPtr(BitPtr);{make FontMap point to BitPtr image}
	FontMap.rowbytes := RowBytes;{row width in bytes, must be even no.}
	FontMap.bounds := tRect;

	HUnlock(Handle(myFont));{unlock it, we're done with Ptr stuff}
	ReleaseResource(Handle(myFont));{if you're done with it}
End;

{once you have the FontMap ....to draw the char '33' from the BitImage:}
var
	p,q:integer;
	SourceRect,DestRect:Rect;
Begin
	SourceRect := FontMap.Bounds;{set top and bottom of Rect}
	SourceRect.left := Locate[33];{coordinate offset to leftside of char 33}
	SourceRect.right := Locate[33 + 1];{offset to rightside of char 33}

	DestRect := SourceRect;{size the destination rect}
	OffSetRect(DestRect,p,q);{locate the DestRect where you want drawn}

	{now do the transfer!}
	CopyBits(FontMap,myWindow^.portBits,SourceRect,DestRect,srcCopy,nil);
End;
